IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_TBL_FIDEL_FATOR_PONTUACAO')
BEGIN

	CREATE TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO](
		[CD_EMP] [int] NOT NULL,
		[CD_TBL_FIDEL] [int] NOT NULL,
		[CD_FATOR] [int] NOT NULL,
		[VLR_INI] [money] NOT NULL,
		[VLR_FIM] [money] NOT NULL,
		[VLR_FATOR] [money] NOT NULL,
		[QTDE_PONTO] [money] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_TBL_FIDEL] ASC,
		[CD_FATOR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END

GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_EMP') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_TBL_FIDEL') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_TBL_FIDEL]  DEFAULT ((0)) FOR [CD_TBL_FIDEL]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_FATOR') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_CD_FATOR]  DEFAULT ((0)) FOR [CD_FATOR]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_INI') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_INI]  DEFAULT ((0)) FOR [VLR_INI]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_FIM') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_FIM]  DEFAULT ((0)) FOR [VLR_FIM]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_FATOR') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_VLR_FATOR]  DEFAULT ((0)) FOR [VLR_FATOR]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_QTDE_PONTO') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] ADD  CONSTRAINT [DF_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_QTDE_PONTO]  DEFAULT ((0)) FOR [QTDE_PONTO]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_EST_PROD_TBL_FIDEL') 
BEGIN
	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_EST_PROD_TBL_FIDEL] FOREIGN KEY([CD_EMP], [CD_TBL_FIDEL])
	REFERENCES [dbo].[EST_PROD_TBL_FIDEL] ([CD_EMP], [CD_TBL_FIDEL])

	ALTER TABLE [dbo].[EST_PROD_TBL_FIDEL_FATOR_PONTUACAO] CHECK CONSTRAINT [FK_EST_PROD_TBL_FIDEL_FATOR_PONTUACAO_EST_PROD_TBL_FIDEL]
END
GO